//
//  MCStackPaneHeader.h
//  MCApplication
//
//  Created by Ali Lalani on Thu Jul 29 2004.
//  Copyright (c) 2004 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "MCStackViewDefines.h"

@class MCStackView,MCStackPane;
@interface MCStackPaneHeader : NSView {
	NSColor *bgColor;
	
	MCStackView *stackView;
	MCStackPane *stackPane;
	
	BOOL isCollapsed;
	
	id configuration;
	
	NSMutableArray *buttons;

	BOOL mouseOverInArrow;
	BOOL mouseDownInArrow;
	NSTrackingRectTag 	arrowTrackingRectTag;
}
// Rect calculating methods
- (NSRect)rectForCollapseButton;
- (NSRect)rectForBackgroundBar;

// Tracking Rect methods
- (void)resetTrackingRects;
- (void)clearTrackingRects;

// Config
- (void)configure;
- (void)setConfiguration:(id)aConfig;
- (id)configuration;

// Accessors
- (void)setBgColor:(NSColor *)aColor;
- (NSColor *)bgColor;
- (BOOL)isCollapsed;
- (MCStackView *)stackView;
- (void)setStackView:(MCStackView *)aStackView;
- (MCStackPane *)stackPane;
- (void)setStackPane:(MCStackPane *)aStackPane;
- (NSMutableArray *)buttons;
- (void)setButtons:(NSMutableArray *)anArray;
@end
